# 
#  Various date operations

setMethod('show', 'date', 
	  function(object) {
	      str <- as(object, 'character')
	      invisible(print.atomic(str,F))
    })
	      

setAs('date', 'character', function(object) {
    if (length(object@format)) 	fmt <- object@format
    else {
	fmt <- .Options[['date.format']]
	if (is.null(fmt)) fmt <- '%d%b%y'
	}
    as.character(timeDate(julian=object@.Data, format=fmt))
    })

print.date <- function(x, quote, format, ...) {
    if (missing(format))  str <- as(x, 'character')
    else {
	x@format <- format
	str <- as(x, 'character')
	}
    if (missing(quote)) quote<-F
    invisible(print.atomic(str,quote))
    }

setMethod('format', 'date', function(x,...)     format(as(x, 'character')))
	
